package com.ejie.aa94a.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejie.aa94a.model.calculo.Bobina;
import com.ejie.aa94a.model.calculo.Resultado;
import com.ejie.aa94a.model.calculo.Transporte;
import com.ejie.aa94a.model.config.Solucion;
import com.ejie.aa94a.model.config.TipoSujecion;
import com.ejie.aa94a.model.config.Vehiculo;

/**
 * 
 * @author GFI-Norte
 * 
 */

public class UtilPruebas {

	private static final Logger logger = LoggerFactory
			.getLogger(UtilPruebas.class);

	private UtilPruebas() {
	}

	public static void testearVeh1Suj1() {
		UtilPruebas.logger.info("[testearVeh1Suj1 - Inicio]");
		Resultado resultado = new Resultado();
		Transporte transporte = new Transporte();
		Solucion solucion = null;
		transporte.setVehiculo(new Vehiculo(Integer.valueOf("1"), null, null,
				null, null));
		transporte.setTipoSujecion(new TipoSujecion(Integer.valueOf("1"), null,
				null, null, null, null));
		List<Bobina> bobinas = null;
		// ///////////////////////
		// A>5
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(6)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 1_1: "
				+ resultado.getTrazaSolucion());
		// ///////////////////////
		// A<=5
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(4.5)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 1_2: "
				+ resultado.getTrazaSolucion());
		// /////////////////////////
		// A-B<=4;
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(3)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(4)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 2_1: "
				+ resultado.getTrazaSolucion());
		// /////////////////////////
		// B<=4;A>4;
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(8)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(2)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 2_2: "
				+ resultado.getTrazaSolucion());
		// /////////////////////////
		// A>4;B>4;A-B>4;
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(12)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(7)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 2_3: "
				+ resultado.getTrazaSolucion());

		// /////////////////////////
		// A-B<4;
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(10)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(8)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(4)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 3_1: "
				+ resultado.getTrazaSolucion());
		// /////////////////////////
		// A-B>=4;
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(10)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(5)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(4)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 3_2: "
				+ resultado.getTrazaSolucion());
		// /////////////////////////
		// A-B<4;D<3;
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(10)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(8)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(4)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(2)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 4_1: "
				+ resultado.getTrazaSolucion());
		// /////////////////////////
		// A-B>=4;B-C>=4;D<3;
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(13)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(8)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(3)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(2)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 4_2: "
				+ resultado.getTrazaSolucion());

		UtilPruebas.logger.info("[testearVeh1Suj1 - Fin]");
	}

	public static void testearVeh1Suj2() {
		UtilPruebas.logger.info("[testearVeh1Suj2 - Inicio]");
		Resultado resultado = new Resultado();
		Transporte transporte = new Transporte();
		Solucion solucion = null;
		transporte.setVehiculo(new Vehiculo(Integer.valueOf("1"), null, null,
				null, null));
		transporte.setTipoSujecion(new TipoSujecion(Integer.valueOf("2"), null,
				null, null, null, null));
		List<Bobina> bobinas = null;
		// ///////////////////////
		// A>5
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(6)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 1_1: "
				+ resultado.getTrazaSolucion());
		// ///////////////////////
		// A<=5
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(4.5)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 1_2: "
				+ resultado.getTrazaSolucion());
		// /////////////////////////
		// A-B<=4;
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(3)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(4)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 2_1: "
				+ resultado.getTrazaSolucion());
		// /////////////////////////
		// B<=4;A>4;
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(8)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(2)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 2_2: "
				+ resultado.getTrazaSolucion());
		// /////////////////////////
		// A>4;B>4;A-B>4;
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(12)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(7)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 2_3: "
				+ resultado.getTrazaSolucion());

		// /////////////////////////
		// A-B<4;
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(10)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(8)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(4)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 3_1: "
				+ resultado.getTrazaSolucion());
		// /////////////////////////
		// A-B>=4;
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(10)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(5)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(4)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 3_2: "
				+ resultado.getTrazaSolucion());
		// /////////////////////////
		// A-B<4;D<3;
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(10)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(8)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(4)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(2)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 4_1: "
				+ resultado.getTrazaSolucion());
		// /////////////////////////
		// A-B>=4;B-C>=4;D<3;
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(13)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(8)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(3)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(2)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 4_2: "
				+ resultado.getTrazaSolucion());

		UtilPruebas.logger.info("[testearVeh1Suj2 - Fin]");
	}

	public static void testearVeh1Suj3() {
		UtilPruebas.logger.info("[testearVeh1Suj3 - Inicio]");

		Resultado resultado = new Resultado();
		Transporte transporte = new Transporte();
		Solucion solucion = null;
		transporte.setVehiculo(new Vehiculo(Integer.valueOf("1"), null, null,
				null, null));
		transporte.setTipoSujecion(new TipoSujecion(Integer.valueOf("3"), null,
				null, null, null, null));
		List<Bobina> bobinas = null;
		// ///////////////////////
		// A<6;B<6; C<6;D<6; E<6;F<6;F<3
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"), Integer.valueOf("450"),
				BigDecimal.valueOf(5)));
		bobinas.add(new Bobina(Integer.valueOf("1500"), Integer.valueOf("450"),
				BigDecimal.valueOf(5)));
		bobinas.add(new Bobina(Integer.valueOf("1500"), Integer.valueOf("450"),
				BigDecimal.valueOf(5)));
		bobinas.add(new Bobina(Integer.valueOf("1500"), Integer.valueOf("450"),
				BigDecimal.valueOf(5)));
		bobinas.add(new Bobina(Integer.valueOf("1500"), Integer.valueOf("450"),
				BigDecimal.valueOf(5)));
		bobinas.add(new Bobina(Integer.valueOf("1500"), Integer.valueOf("450"),
				BigDecimal.valueOf(2)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 1_1: "
				+ resultado.getTrazaSolucion());

		UtilPruebas.logger.info("[testearVeh1Suj3 - Fin]");
	}

	public static void testearVeh1Suj4() {
		UtilPruebas.logger.info("[testearVeh1Suj4 - Inicio]");
		Resultado resultado = new Resultado();
		Transporte transporte = new Transporte();
		Solucion solucion = null;
		transporte.setVehiculo(new Vehiculo(Integer.valueOf("1"), null, null,
				null, null));
		transporte.setTipoSujecion(new TipoSujecion(Integer.valueOf("4"), null,
				null, null, null, null));
		List<Bobina> bobinas = null;
		// ///////////////////////
		// A>=2*B;A<=3*B;A<=17
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(15)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(6)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 1_1: "
				+ resultado.getTrazaSolucion());
		UtilPruebas.logger.info("[testearVeh1Suj4 - Fin]");
	}

	public static void testearVeh2Suj1() {
		UtilPruebas.logger.info("[testearVeh2Suj1 - Inicio]");
		Resultado resultado = new Resultado();
		Transporte transporte = new Transporte();
		Solucion solucion = null;
		transporte.setVehiculo(new Vehiculo(Integer.valueOf("2"), null, null,
				null, null));
		transporte.setTipoSujecion(new TipoSujecion(Integer.valueOf("1"), null,
				null, null, null, null));
		List<Bobina> bobinas = null;
		// ///////////////////////
		// A>=5
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(6)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 1_1: "
				+ resultado.getTrazaSolucion());
		// ///////////////////////
		// A<5
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(4.5)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 1_2: "
				+ resultado.getTrazaSolucion());
		// /////////////////////////
		// A>=10;B>=10;A<20;B<20;A-B<4;WIDTH_A<=1600; WIDTH_B<=1600
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(12)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(11)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 2_1: "
				+ resultado.getTrazaSolucion());
		// /////////////////////////
		// A>=10;B>=10; A<20;B<20;A-B>=4;WIDTH_A<=1600; WIDTH_B<=1600
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(16)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(11)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 2_2: "
				+ resultado.getTrazaSolucion());
		// /////////////////////////
		// A<=10;B<=10;A-B<4;WIDTH_A<=1600; WIDTH_B<=1600
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(8)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(5)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 2_3: "
				+ resultado.getTrazaSolucion());

		// /////////////////////////
		// A>10;B<10;A>=17;A<=20; WIDTH_B<=1000
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(18)));
		bobinas.add(new Bobina(Integer.valueOf("1500"), Integer.valueOf("900"),
				BigDecimal.valueOf(8)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 3_1: "
				+ resultado.getTrazaSolucion());
		// /////////////////////////
		// A>10;B<10;A<17; WIDTH_A<=1000
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(15)));
		bobinas.add(new Bobina(Integer.valueOf("1500"), Integer.valueOf("900"),
				BigDecimal.valueOf(9)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 3_2: "
				+ resultado.getTrazaSolucion());
		// /////////////////////////
		// A<=10;B<=10;C<=3;WIDTH_A<=1600; WIDTH_B<=1600
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(10)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(8)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(2)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 4_1: "
				+ resultado.getTrazaSolucion());
		UtilPruebas.logger.info("[testearVeh2Suj1 - Fin]");
	}

	public static void testearVeh2Suj2() {
		UtilPruebas.logger.info("[testearVeh2Suj2 - Inicio]");
		Resultado resultado = new Resultado();
		Transporte transporte = new Transporte();
		Solucion solucion = null;
		transporte.setVehiculo(new Vehiculo(Integer.valueOf("2"), null, null,
				null, null));
		transporte.setTipoSujecion(new TipoSujecion(Integer.valueOf("2"), null,
				null, null, null, null));
		List<Bobina> bobinas = null;
		// ///////////////////////
		// A>=5
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(6)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 1_1: "
				+ resultado.getTrazaSolucion());
		// ///////////////////////
		// A<5
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(4.5)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 1_2: "
				+ resultado.getTrazaSolucion());
		// /////////////////////////
		// A>=10;B>=10;A-B<4
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(12)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(11)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 2_1: "
				+ resultado.getTrazaSolucion());
		// /////////////////////////
		// A>=10;B>=10;A-B>=4
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(16)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(11)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 2_2: "
				+ resultado.getTrazaSolucion());
		// /////////////////////////
		// A<=10;B<=10;A-B<4
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(8)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(9)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 2_3: "
				+ resultado.getTrazaSolucion());

		// /////////////////////////
		// A>10;B<10;A>=17;A<=20
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(7)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(18)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 3_1: "
				+ resultado.getTrazaSolucion());
		// /////////////////////////
		// A>10;B<10;A<17
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(16)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(8)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 3_2: "
				+ resultado.getTrazaSolucion());
		// /////////////////////////

		// /////////////////////////
		// A>=10;B>=10;A-B<4;C<=3
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(12)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(11)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(2)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 2_1: "
				+ resultado.getTrazaSolucion());
		// /////////////////////////
		// A>=10;B>=10;A-B>=4;C<=3
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(16)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(11)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(2)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 2_2: "
				+ resultado.getTrazaSolucion());
		// /////////////////////////
		// A<=10;B<=10;A-B<4;C<=3
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(8)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(9)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(2)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 2_3: "
				+ resultado.getTrazaSolucion());

		// /////////////////////////
		// A>10;B<10;A>=17;A<=20;C<=3
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(7)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(18)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(2)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 3_1: "
				+ resultado.getTrazaSolucion());
		// /////////////////////////
		// A>10;B<10;A<17;C<=3
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(16)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(8)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(2)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 3_2: "
				+ resultado.getTrazaSolucion());
		// /////////////////////////

		UtilPruebas.logger.info("[testearVeh2Suj2 - Fin]");
	}

	public static void testearVeh2Suj3() {
		UtilPruebas.logger.info("[testearVeh2Suj3 - Inicio]");

		Resultado resultado = new Resultado();
		Transporte transporte = new Transporte();
		Solucion solucion = null;
		transporte.setVehiculo(new Vehiculo(Integer.valueOf("2"), null, null,
				null, null));
		transporte.setTipoSujecion(new TipoSujecion(Integer.valueOf("3"), null,
				null, null, null, null));
		List<Bobina> bobinas = null;
		// ///////////////////////
		// A<=6; B<=6; C<=6; D<=6; E<=6; E<=3
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"), Integer.valueOf("450"),
				BigDecimal.valueOf(5)));
		bobinas.add(new Bobina(Integer.valueOf("1500"), Integer.valueOf("450"),
				BigDecimal.valueOf(5)));
		bobinas.add(new Bobina(Integer.valueOf("1500"), Integer.valueOf("450"),
				BigDecimal.valueOf(5)));
		bobinas.add(new Bobina(Integer.valueOf("1500"), Integer.valueOf("450"),
				BigDecimal.valueOf(5)));
		bobinas.add(new Bobina(Integer.valueOf("1500"), Integer.valueOf("450"),
				BigDecimal.valueOf(2)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 1_1: "
				+ resultado.getTrazaSolucion());

		UtilPruebas.logger.info("[testearVeh2Suj3 - Fin]");
	}

	public static void testearVeh2Suj4() {
		UtilPruebas.logger.info("[testearVeh2Suj4 - Inicio]");
		Resultado resultado = new Resultado();
		Transporte transporte = new Transporte();
		Solucion solucion = null;
		transporte.setVehiculo(new Vehiculo(Integer.valueOf("2"), null, null,
				null, null));
		transporte.setTipoSujecion(new TipoSujecion(Integer.valueOf("4"), null,
				null, null, null, null));
		List<Bobina> bobinas = null;
		// ///////////////////////
		// A>=2*B;A<=3*B;A<=19
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(15)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(6)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 1_1: "
				+ resultado.getTrazaSolucion());
		UtilPruebas.logger.info("[testearVeh2Suj4 - Fin]");
	}

	public static void testearVeh3Suj1() {
		UtilPruebas.logger.info("[testearVeh3Suj1 - Inicio]");
		Resultado resultado = new Resultado();
		Transporte transporte = new Transporte();
		Solucion solucion = null;
		transporte.setVehiculo(new Vehiculo(Integer.valueOf("3"), null, null,
				null, null));
		transporte.setTipoSujecion(new TipoSujecion(Integer.valueOf("1"), null,
				null, null, null, null));
		List<Bobina> bobinas = null;
		// ///////////////////////
		//
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(6)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 1_1: "
				+ resultado.getTrazaSolucion());
		// ///////////////////////
		// WIDTH_A<=2000;WIDTH_B<=2000;
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(4.5)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(6)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 1_2: "
				+ resultado.getTrazaSolucion());

		UtilPruebas.logger.info("[testearVeh3Suj1 - Fin]");
	}

	public static void testearVeh3Suj2() {
		UtilPruebas.logger.info("[testearVeh3Suj2 - Inicio]");
		Resultado resultado = new Resultado();
		Transporte transporte = new Transporte();
		Solucion solucion = null;
		transporte.setVehiculo(new Vehiculo(Integer.valueOf("3"), null, null,
				null, null));
		transporte.setTipoSujecion(new TipoSujecion(Integer.valueOf("2"), null,
				null, null, null, null));
		List<Bobina> bobinas = null;
		// ///////////////////////
		// WIDTH_A>=600;WIDTH_A<=2000;
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(6)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 1_1: "
				+ resultado.getTrazaSolucion());
		// ///////////////////////
		// WIDTH_A>=600;WIDTH_A<=2000;WIDTH_B>=600;WIDTH_B<=2000;
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(4.5)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(4.5)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 1_2: "
				+ resultado.getTrazaSolucion());
		UtilPruebas.logger.info("[testearVeh3Suj2 - Fin]");
	}

	public static void testearVeh3Suj3() {
		UtilPruebas.logger.info("[testearVeh3Suj3 - Inicio]");

		Resultado resultado = new Resultado();
		Transporte transporte = new Transporte();
		Solucion solucion = null;
		transporte.setVehiculo(new Vehiculo(Integer.valueOf("3"), null, null,
				null, null));
		transporte.setTipoSujecion(new TipoSujecion(Integer.valueOf("3"), null,
				null, null, null, null));
		List<Bobina> bobinas = null;
		// ///////////////////////
		// A<=5;B<=5;C<=5;D<=5;E<=5;E<=3
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"), Integer.valueOf("450"),
				BigDecimal.valueOf(4)));
		bobinas.add(new Bobina(Integer.valueOf("1500"), Integer.valueOf("450"),
				BigDecimal.valueOf(4)));
		bobinas.add(new Bobina(Integer.valueOf("1500"), Integer.valueOf("450"),
				BigDecimal.valueOf(4)));
		bobinas.add(new Bobina(Integer.valueOf("1500"), Integer.valueOf("450"),
				BigDecimal.valueOf(4)));
		bobinas.add(new Bobina(Integer.valueOf("1500"), Integer.valueOf("450"),
				BigDecimal.valueOf(2)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 1_1: "
				+ resultado.getTrazaSolucion());

		UtilPruebas.logger.info("[testearVeh3Suj3 - Fin]");
	}

	public static void testearVeh3Suj4() {
		UtilPruebas.logger.info("[testearVeh3Suj4 - Inicio]");
		Resultado resultado = new Resultado();
		Transporte transporte = new Transporte();
		Solucion solucion = null;
		transporte.setVehiculo(new Vehiculo(Integer.valueOf("3"), null, null,
				null, null));
		transporte.setTipoSujecion(new TipoSujecion(Integer.valueOf("4"), null,
				null, null, null, null));
		List<Bobina> bobinas = null;
		// ///////////////////////
		// A>=2*B
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(15)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(6)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 1_1: "
				+ resultado.getTrazaSolucion());
		UtilPruebas.logger.info("[testearVeh3Suj4 - Fin]");
	}

	public static void testearVeh4Suj1() {
		UtilPruebas.logger.info("[testearVeh4Suj1 - Inicio]");
		Resultado resultado = new Resultado();
		Transporte transporte = new Transporte();
		Solucion solucion = null;
		transporte.setVehiculo(new Vehiculo(Integer.valueOf("4"), null, null,
				null, null));
		transporte.setTipoSujecion(new TipoSujecion(Integer.valueOf("1"), null,
				null, null, null, null));
		List<Bobina> bobinas = null;
		// ///////////////////////
		//
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(6)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 1_1: "
				+ resultado.getTrazaSolucion());
		// ///////////////////////
		// WIDTH_A<=2000;WIDTH_B<=2000;
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(4.5)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(6)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 1_2: "
				+ resultado.getTrazaSolucion());
		UtilPruebas.logger.info("[testearVeh4Suj1 - Fin]");
	}

	public static void testearVeh4Suj2() {
		UtilPruebas.logger.info("[testearVeh4Suj2 - Inicio]");
		Resultado resultado = new Resultado();
		Transporte transporte = new Transporte();
		Solucion solucion = null;
		transporte.setVehiculo(new Vehiculo(Integer.valueOf("4"), null, null,
				null, null));
		transporte.setTipoSujecion(new TipoSujecion(Integer.valueOf("2"), null,
				null, null, null, null));
		List<Bobina> bobinas = null;

		// ///////////////////////
		// WIDTH_A>=600;WIDTH_A<=2000;
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"), Integer.valueOf("700"),
				BigDecimal.valueOf(6)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 1_1: "
				+ resultado.getTrazaSolucion());
		// ///////////////////////
		// WIDTH_A>=600;WIDTH_A<=2000;WIDTH_B>=600;WIDTH_B<=2000;
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"), Integer.valueOf("800"),
				BigDecimal.valueOf(4.5)));
		bobinas.add(new Bobina(Integer.valueOf("1500"), Integer.valueOf("800"),
				BigDecimal.valueOf(6)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 1_2: "
				+ resultado.getTrazaSolucion());

		UtilPruebas.logger.info("[testearVeh4Suj2 - Fin]");
	}

	public static void testearVeh4Suj3() {
		UtilPruebas.logger.info("[testearVeh4Suj3 - Inicio]");

		Resultado resultado = new Resultado();
		Transporte transporte = new Transporte();
		Solucion solucion = null;
		transporte.setVehiculo(new Vehiculo(Integer.valueOf("4"), null, null,
				null, null));
		transporte.setTipoSujecion(new TipoSujecion(Integer.valueOf("3"), null,
				null, null, null, null));
		List<Bobina> bobinas = null;
		// ///////////////////////
		// A<=5;B<=5;C<=5;D<=5;E<=5;E<=3
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"), Integer.valueOf("450"),
				BigDecimal.valueOf(4)));
		bobinas.add(new Bobina(Integer.valueOf("1500"), Integer.valueOf("450"),
				BigDecimal.valueOf(4)));
		bobinas.add(new Bobina(Integer.valueOf("1500"), Integer.valueOf("450"),
				BigDecimal.valueOf(4)));
		bobinas.add(new Bobina(Integer.valueOf("1500"), Integer.valueOf("450"),
				BigDecimal.valueOf(4)));
		bobinas.add(new Bobina(Integer.valueOf("1500"), Integer.valueOf("450"),
				BigDecimal.valueOf(2)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 1_1: "
				+ resultado.getTrazaSolucion());

		UtilPruebas.logger.info("[testearVeh4Suj3 - Fin]");
	}

	public static void testearVeh4Suj4() {
		UtilPruebas.logger.info("[testearVeh4Suj4 - Inicio]");
		Resultado resultado = new Resultado();
		Transporte transporte = new Transporte();
		Solucion solucion = null;
		transporte.setVehiculo(new Vehiculo(Integer.valueOf("4"), null, null,
				null, null));
		transporte.setTipoSujecion(new TipoSujecion(Integer.valueOf("4"), null,
				null, null, null, null));
		List<Bobina> bobinas = null;
		// ///////////////////////
		// A>=2*B
		bobinas = new ArrayList<Bobina>();
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(15)));
		bobinas.add(new Bobina(Integer.valueOf("1500"),
				Integer.valueOf("1500"), BigDecimal.valueOf(6)));
		// /////////////////
		transporte.setBobinas(bobinas);
		// Ordena las bobinas por peso en descendente
		Collections.sort(transporte.getBobinas());
		// Realización del cálculo de la solución
		solucion = UtilSolucion.obtenerSolucion(transporte);
		resultado.setSolucion(solucion);
		if (solucion != null) {
			resultado.setUbicaciones(transporte.getBobinas());
		}
		UtilPruebas.logger.info("Resultado Situacion 1_1: "
				+ resultado.getTrazaSolucion());
		UtilPruebas.logger.info("[testearVeh4Suj4 - Fin]");
	}
}